--[[---------------------------------------------------------------------------
	Chocolatier Two Logo Editor: "Simple" Version
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------

local ts = (gSim.logo.ts - 10) / (100-10)

local w = 700
local h = 365
local logoW = 350
local logoH = 200
local dY = 28

local items = {}
for item in LItem:KnownRecipes() do
	local total = item.inventory + item.sold
	if total > 0 then table.insert(items, item.name.."_big") end
end

if not gSim.logo.tfo then gSim.logo.tfo = 1 end

-------------------------------------------------------------------------------
-- Basic color options (RGB)

local colorOptions =
{
	{255, 255, 255},		-- White
	{209, 027, 027},		-- Red
	{245, 121, 012},		-- Orange
	{023, 148, 016},		-- Green
	{033, 094, 217},		-- Blue
	{150, 029, 229},		-- Purple
	{242, 128, 227},		-- Pink
	{000, 000, 000},		-- Black
}

local x = logoW+20
local y = 205
local colorSelectors = {}
for _,c in ipairs(colorOptions) do
	local r,g,b = c[1],c[2],c[3]
	table.insert(colorSelectors,
		Button { x=x,y=y,w=24,h=24, graphics={}, command=function() SetTextColor(r,g,b,255) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, color=Color(0,0,0) },
			Rectangle { x=2,y=2,w=kMax-2,h=kMax-2, color=Color(r,g,b) } })
	x = x + 27
end

-------------------------------------------------------------------------------
-- Randomize

local function LogoRandomizer()
	-- FIRSTPEEK: RandomLogo, time-stamp, weeks
	if fpWrite then fpWrite { "RandomLogo", gSim.weeks } end

	local n

	-- pick a color
	n = bsgRandom(1, table.getn(colorOptions))
	local c = colorOptions[n]
	SetTextColor(c[1],c[2],c[3],255)
	
	-- randomly outline text
	n = bsgRandom(1,100)
	if n > 50 then ToggleOutline() end
	
	-- Randomize a text/graphic layout
	n = bsgRandom(1,100)
	local x = 1
	if n > 66 then x = 0
	elseif n > 33 then x = .5
	end
	SetTextPosition(x,.5) SetGraphicPosition(1-x,.5)

	-- pick a background
	-- pick a graphic
	-- pick a font
	-- (This is done in C++ it's easier)
	RandomizeLogo()
end

-------------------------------------------------------------------------------

MakeDialog
{
	name="simplelogo",
	Frame
	{
		x=kCenter,y=50,w=w,h=h,
		LogoEditor
		{
			x=0,y=0,w=kMax,h=kMax,
			logo=gSim.logo,
			logox=5,logoy=85,
			itemsAllowed=items,

			SetStyle(sliderStyle),
			AppendStyle { font=dialogFont },

			Window { x=56,y=0, fit=true,
				Text { x=0,y=0,w=450,h=20, label="logo_name", font=dialogFont },
				Bitmap { x=0,y=20, image="control/company_entry_field",
					TextEdit { x=18,y=5,w=418,h=21, name="nameedit", label=(gSim.logo.t or "BLAHBLAH"), length=25, ignore=kIgnoreBadSignChars }, },
				TextButton { x=460,y=20, label="ok", scale=30/ui.devButtonH, default=true,
					command = function()
						logoChanged = true
						SetLogoText(GetLabel("nameedit"))
					end
				},
			},

			Text { x=logoW,y=55,w=350,h=20, label="logo_background" },
			Slider { x=logoW+20,y=75,w=310,name="background", value=0 },
			
			Text { x=logoW,y=105,w=350,h=20, label="logo_graphic" },
			Slider { x=logoW+20,y=125,w=310,name="graphic", value=0 },

			Text { x=logoW,y=155,w=350,h=20, label="logo_basicfont" },
			Slider { x=logoW+20,y=175,w=310,name="font", value=0 },
			Group(colorSelectors),
			
--			TextButton { x=kMax-ui.devButtonW/2,y=205, scale=.5, type=kRadio, label="logo_outline", command=function() ToggleOutline() end },
			Button { x=kMax-ui.devButtonW/2-15,y=197, scale=.5, type=kToggle, name="outline", graphics=CheckButtonGraphics, command=function() ToggleOutline() end },
			Text { x=kMax-ui.devButtonW/2-15+30,y=200,w=ui.devButtonW/2,h=32, label="logo_outline", flags=kVAlignCenter+kHAlignLeft },

			Text { x=logoW,y=235,w=350,h=20, label="logo_basiclayout" },
			Button { x=logoW+20,y=255, graphics = {"control/layoutA"},
				command=function() SetTextPosition(0,.5) SetGraphicPosition(1,.5) end },
			Button { x=logoW+20+105,y=255, graphics = {"control/layoutB"},
				command=function() SetTextPosition(.5,.5) SetGraphicPosition(.5,.5) end },
			Button { x=logoW+20+210,y=255, graphics = {"control/layoutA"}, hflip=true,
				command=function() SetTextPosition(1,.5) SetGraphicPosition(0,.5) end },
				
			SetStyle(standardStyle),
			TextButton { x=kCenter+ui.devButtonW,y=320, name="ok", label="done",
				command=function()
					local logo = GetLogoString()
					if logo then
						logo = loadstring(logo)
						if type(logo) == "function" then logo = logo() end
						if logo then gSim.logo = logo end
					end
					-- FIRSTPEEK: BasicLogoClose, time-stamp, weeks
					if fpWrite then fpWrite { "BasicLogoClose", gSim.weeks } end
					CloseWindow()
--					SwapToModal("ui/portview.lua")
--					StopPulsing()
				end },

			TextButton { x=kCenter,y=320, name="randomize", label="randomize", command=function() LogoRandomizer() end },

			TextButton { x=kCenter-ui.devButtonW,y=320, label="logo_advanced",
				command = function()
					local logo = GetLogoString()
					if logo then
						logo = loadstring(logo)
						if type(logo) == "function" then logo = logo() end
						if logo then gSim.logo = logo end
					end
					PopModal("simplelogo")
					DisplayDialog { "ui/logoedit.lua" }
				end },
		},
	},
}

if gSim.logo.tfo and (gSim.logo.tfo > 0) then
	SetButtonToggleState("outline", true)
end
